/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class EnigmaEngine1 {
    public int[] pixels;
    public short[][] chdata;
    public BufferedImage buffer;
    public BufferedImage frontbuffer;
    WritableRaster raster;
    public Graphics bg;
    public Graphics bfg;
    public int width = 0;
    public int height = 0;
    public int owidth = 0;
    public int oheight = 0;
    public int framerate = 30;
    public int speed = 1;
    public int numchan = 4;
    public Graphics out;
    boolean autoout = false;
    boolean interlace = false;
    boolean autoscramble = true;
    public boolean run = false;
    public boolean pause;
    public boolean paused = false;
    public final int L = 1;
    public final int R = 2;
    public final int U = 4;
    public final int D = 8;
    public final int UR = 16;
    public final int UL = 32;
    public final int DR = 64;
    public final int DL = 128;
    int[] selectorpts;
    EnigmaSelector[] selectors;
    int twidth;
    int theight;
    int towidth;
    int toheight;
    int todo = 0;
    int f = 0;
    public int BLANK = -16776112;
    public int ARBIT = -16777177;
    int isc = 2;

    public EnigmaEngine1() {
        this.setResolutionAct(128, 128);
        int[] selectorpts = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        EnigmaSelector[] selectors = new EnigmaSelector[]{new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.left(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.right(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.up(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.down(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.UR(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.UL(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.DR(i);
            }
        }, new EnigmaSelector(){

            public int select(int i) {
                return EnigmaEngine1.this.DL(i);
            }
        }};
        this.selectorpts = selectorpts;
        this.selectors = selectors;
    }

    public void setChannelCount(int s) {
        this.numchan = s;
        this.chdata = new short[this.width * this.height][this.numchan];
    }

    public void setSpeed(int s) {
        this.speed = s;
    }

    public void setInterlace(boolean yes) {
        this.interlace = yes;
    }

    public Graphics getBackGraphics() {
        return this.bg;
    }

    public Graphics getFrontGraphics() {
        return this.bfg;
    }

    public void setOutput(Graphics outgraphics) {
        this.out = outgraphics;
        this.autoout = this.out != null;
    }

    public void setFramerate(int i) {
        this.framerate = i;
    }

    public void setResolution(int w, int h) {
        this.twidth = w;
        this.theight = h;
        this.todo = 1;
    }

    public void setResolutionAct(int w, int h) {
        this.width = w;
        this.height = h;
        this.buffer = null;
        this.buffer = new BufferedImage(this.width, this.height, 1);
        this.bg = this.buffer.getGraphics();
        this.raster = this.buffer.getRaster();
        this.pixels = new int[this.width * this.height];
        this.chdata = new short[this.width * this.height][this.numchan];
        if (this.width > this.owidth || this.height > this.oheight) {
            this.setOutputSizeAct(this.width, this.height);
        }
    }

    public void setOutputSize(int w, int h) {
        this.towidth = w;
        this.toheight = h;
        this.todo = 2;
    }

    public void setOutputSizeAct(int w, int h) {
        this.owidth = w;
        this.oheight = h;
        this.frontbuffer = null;
        this.frontbuffer = new BufferedImage(this.owidth, this.oheight, 1);
        this.bfg = this.frontbuffer.getGraphics();
        if (this.width > this.owidth || this.height > this.oheight) {
            this.setResolutionAct(w, h);
        }
    }

    public void toScreen() {
        this.out.drawImage(this.buffer, 0, 0, this.owidth, this.oheight, 0, 0, this.width, this.height, null);
    }

    public void handleFrontBuffer() {
    }

    public void todo() {
        if (this.todo == 1) {
            this.setResolutionAct(this.twidth, this.theight);
            this.todo = 0;
        } else if (this.todo == 2) {
            this.setOutputSizeAct(this.towidth, this.toheight);
            this.todo = 0;
        }
    }

    public void run() {
        this.run = true;
        long time = System.currentTimeMillis();
        while (this.run) {
            try {
                this.todo();
                if (this.pause) {
                    System.out.println("paused");
                    this.paused = true;
                }
                while (this.pause) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.paused) {
                    this.paused = false;
                    time = System.currentTimeMillis();
                    System.out.println("unpaused");
                }
                this.processLoop();
                if (this.autoout) {
                    this.toScreen();
                } else {
                    this.bfg.drawImage(this.buffer, 0, 0, this.owidth, this.oheight, 0, 0, this.width, this.height, null);
                    this.handleFrontBuffer();
                }
                while (System.currentTimeMillis() - (time += (long)(1000 / this.framerate)) < (long)(1000 / this.framerate - 1)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processLoop() {
        this.updateMain();
        this.raster.getDataElements(0, 0, this.width, this.height, this.pixels);
        int i = 0;
        while (i < this.speed) {
            this.updateSand();
            ++i;
        }
        this.raster.setDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updateSand() {
        ++this.f;
        if (this.interlace) {
            int y = this.height - 2 - this.f % this.isc;
            while (y > 0) {
                int x;
                int v = y % 2 == 0 ? -this.isc : this.isc;
                int n = v;
                if (v > 0) {
                    x = this.f / this.isc % this.isc + 1;
                    while (x < this.width) {
                        this.processSandParticle(y * this.width + x);
                        x += this.isc;
                    }
                } else {
                    x = this.width - 1;
                    while (x > this.f / this.isc % this.isc) {
                        this.processSandParticle(y * this.width + x);
                        x += this.isc;
                    }
                }
                y -= this.isc;
            }
        } else {
            int y = this.height - 2;
            while (y > 0) {
                int x;
                int v = this.f % 2 == 0 ? -1 : 1;
                int n = v;
                if (v > 0) {
                    x = 0;
                    while (x < this.width) {
                        this.processSandParticle(y * this.width + x);
                        ++x;
                    }
                } else {
                    x = this.width - 1;
                    while (x > -1) {
                        this.processSandParticle(y * this.width + x);
                        --x;
                    }
                }
                --y;
            }
        }
    }

    public void updateMain() {
    }

    public void processSandParticle(int i) {
    }

    public int left(int i) {
        return i - 1;
    }

    public int up(int i) {
        return i - this.width;
    }

    public int down(int i) {
        return i + this.width;
    }

    public int right(int i) {
        return i + 1;
    }

    public int UL(int i) {
        return i - this.width - 1;
    }

    public int UR(int i) {
        return i - this.width + 1;
    }

    public int DR(int i) {
        return i + this.width + 1;
    }

    public int DL(int i) {
        return i + this.width - 1;
    }

    public int select(int j, int search, int dir) {
        int loc = -1;
        if (search == this.ARBIT) {
            return this.selectors[0].select(j);
        }
        int i = 0;
        while (i < this.selectors.length) {
            if ((dir & this.selectorpts[i]) == this.selectorpts[i] && (loc = this.selectors[i].select(j)) > 0 && this.pixels[loc] == search) {
                return loc;
            }
            ++i;
        }
        return -1;
    }

    public void scrambleSelectors() {
        double action = Math.random();
        if (action < 0.8) {
            return;
        }
        int i = (int)(Math.random() * (double)this.selectors.length);
        int pointer = this.selectorpts[i];
        EnigmaSelector selector = this.selectors[i];
        int index = (int)(Math.random() * (double)this.selectors.length);
        this.selectorpts[i] = this.selectorpts[index];
        this.selectors[i] = this.selectors[index];
        this.selectorpts[index] = pointer;
        this.selectors[index] = selector;
    }

    public void shiftSelectors() {
        int pointer = this.selectorpts[0];
        EnigmaSelector selector = this.selectors[0];
        int i = 1;
        while (i < this.selectors.length) {
            this.selectorpts[i - 1] = this.selectorpts[i];
            this.selectors[i - 1] = this.selectors[i];
            ++i;
        }
        this.selectorpts[this.selectorpts.length - 1] = pointer;
        this.selectors[this.selectors.length - 1] = selector;
    }

    public boolean chance(double d) {
        return Math.random() < d;
    }

    static interface EnigmaSelector {
        public int select(int var1);
    }
}

